﻿// JScript File

var CONST_ERROR_CHECK_VALID_NULLOREMPTY = -1;
var CONST_ERROR_CHECK_VALID_OTHERS = -4;

var CONST_ERROR_COUPLET_LENGTH_MISMATCH = -1;
var CONST_ERROR_COUPLET_NOT_CHINESE = -2;
var CONST_ERROR_COUPLET_INVALID_CHINESE = -3;
var CONST_ERROR_COUPLET_SERVICE_TIMEOUT = -4;
var CONST_ERROR_COUPLET_OTHERS = -5;


function GetXiaLian(shanglian, locker, isUpdate, context)
{
    ShowWaitIndicator( gConst_display_inline, gConst_AlertDiv, "生成下联..." );
    Msra.Couplet.Web.CoupletsWS_V2.GetXiaLian(
        shanglian,
        locker,
        isUpdate,
        XLSucceededCallbackWithContext,
        XialianFailedCallbackWithContext,
        context);
}

function XLSucceededCallbackWithContext(result, userContext, methodName)
{
    // Do something
    
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
	var jsonResult = Sys.Serialization.JavaScriptSerializer.serialize(result);
	
	gXLResult = result;
    var divXiaLianView = $find( gConst_divXiaLianResults );
    divXiaLianView.clear();
    if( null == gXLResult )
    {
        // Show error message.
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp),g_const_sErrorMsgNoXialianCandidate, -365, 135);
        return;
    }
    else
    {
        
        divXiaLianView.set_result(gXLResult, userContext);
        if(!userContext.getIsUpdate())
        {
            divXiaLianView.set_Normal(true);
        }
        
        $get( "hf_result_xl" ).value = jsonResult;
	    $get( gConst_hf_cur_normal_select ).value = "-1";
	    $get( gConst_hf_cur_adv_select ).value = "**********";
	    $get( gConst_hf_cur_hp_select ).value = "-1";
	    $get( gConst_hf_curSelection ).value = "0";
    }
}

// This is the callback function invoked if the Web service failed.
// It accepts the error object as a parameter.
function XialianFailedCallbackWithContext(error, userContext, methodName)
{
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
    var divXiaLianView = $find( gConst_divXiaLianResults );
    divXiaLianView.clear();
    gXLResult = null;
    
    var errorCode = parseInt(error.get_message().split("|")[0]);
    switch(errorCode)
    {
        case CONST_ERROR_COUPLET_INVALID_CHINESE:
            ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgInvalidChineseString, -365, 135);
            break;
        default:
            ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgNoXialianCandidate, -365, 135);
            break;
    }
}

//////////////////////////////////////////////////////////////

function GetHengPi(shanglian, xialian, context)
{
    ShowWaitIndicator( gConst_display_inline, gConst_AlertDiv, "生成横批..." );
    Msra.Couplet.Web.CoupletsWS_V2.GetHengPi(
        shanglian,
        xialian,
        HPSucceededCallbackWithContext,
        HengpiFailedCallbackWithContext,
        context);
}

function HPSucceededCallbackWithContext(result, userContext, methodName)
{
    // Do something
    
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
	var jsonResult = Sys.Serialization.JavaScriptSerializer.serialize(result);
    
    gHPResult = result;
    var hp = $find(gConst_divHengPiResults);
    hp.set_result(gHPResult);
    $get(gConst_hf_result_hp).value = jsonResult;
}





// This is the callback function invoked if the Web service failed.
// It accepts the error object as a parameter.
function HengpiFailedCallbackWithContext(error,userContext, methodName)
{
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
    ShowCoupletErrorMsg(0, $get(g_const_imgHelp), g_const_sErrorMsgNoHengpiCandidate, -365, 165);
}


function ShowCoupletErrorMsg(errorCode, referencedDOMObject, message, positionX, positionY)
{
    var hint = $find( gConst_div_hint );
    hint.set_position(referencedDOMObject, message, positionX, positionY);
}

////////////////////////////////////////////////////////////////////////

function IsValidChineseString(inputString, context)
{
    ShowWaitIndicator( gConst_display_inline, gConst_AlertDiv, '' );
    Msra.Couplet.Web.CoupletsWS_V2.IsValidChineseString(
        inputString,
        CheckValidSucceededCallbackWithContext,
        CheckValidFailedCallbackWithContext,
        context);
}

function CheckValidSucceededCallbackWithContext(result, userContext, methodName)
{
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
    var currentStep = userContext.getStepFrom();
    switch(currentStep)
    {
        case 0: 
            var stepTo = userContext.getStepTo();
            if(stepTo == 1)
            {
                        
                var newSL = $get( gConst_ShangLian ).value;
                var newXL = GetDynamicLianString(gConst_XiaLian);
                var fChanged = false;
                if( $get( g_sLastQueryShanglian ).value != newSL )
                {
                    $get( g_sLastQueryShanglian ).value = newSL;
                    fChanged = true;
                }
                
                if( $get( g_sLastQueryXialian ).value != newXL )
                {
                    $get( g_sLastQueryXialian ).value = newXL;
                    fChanged = true;
                }
                if(fChanged)
                {
                    var preview = $find( gConst_tbl_preview );
                    preview.set_lian(gConst_ShangLian, $get( gConst_ShangLian ).value );
                    preview.set_lian(gConst_XiaLian, "" );
                    preview.GenerateLian();
                    
                    $get( "hf_locker" ).value = "";
                    for(var i = 0; i < gShangLianLength; i++)
                    {
                        $get( "hf_locker" ).value += '0';
                    }
                    
                    //when clicking '确认上联'
                    //1.clear normal view ,maybe normal view result is not null
                    //2.hide 'show adv' button avoiding show incorrect advance view
                    //3.reset value of adv button to "Show Adv.->", so that when user click '确认上联' again,he will see the right button.
                    var Xialian = $find(gConst_divXiaLianResults);
                    Xialian.clear();
                    Xialian.constructInput($get( gConst_ShangLian ).value);
                    
                    AJAXGetXLResult(false);
                        
                    $get( gConst_hf_result_hp_locker ).value = "";
                    var preview = $find(gConst_tbl_preview);
                    preview.updateDynamicHP(""); 
                    
                    var cHengpi = $find(gConst_divHengPiResults);
                    cHengpi.set_inputHengpi("");
                }
                ChangeLayer(1);
            }
            else if(stepTo == 2)
            {
                // here same as case 1.
                if(userContext.getState() == true)
                {
                    ChangeLayer(2);
                    getHengpi();
                }
                else
                {
                    var context = new Utility.RequestContext(userContext.getShanglian(), userContext.getXialian(), "", "", 
                        userContext.getStepFrom(), userContext.getStepTo(), true);
                    IsValidChineseString(userContext.getXialian(), context);
                }
            }
            break;
        case 1:
            // Code here is a little bit difficult to understand. For checking the validity of both shanglian and xialian before
            // get hengpi, we should check the validity separately. Here if the state of ocontext is false, then that means shanglian
            // checking succeeded. We should do xialian checking consequently.
            if(userContext.getState() == true)
            {
                ChangeLayer(2);
                getHengpi();
            }
            else
            {
                var context = new Utility.RequestContext(userContext.getShanglian(), userContext.getXialian(), "", "", 
                    userContext.getStepFrom(), userContext.getStepTo(), true);
                IsValidChineseString(userContext.getXialian(), context);
            }
            break;
        case 2:
            var sCurrentHengpi = userContext.getHengpi();
            
            var sb_hp = new Sys.StringBuilder();
            for (var i = sCurrentHengpi.length-1; i >=0 ; i--)
            {
                sb_hp.append(sCurrentHengpi.charAt(i));
            }
            var sReverseHengpi = sb_hp.toString();
            
            if(!userContext.getState())
            {
                redirectToShowPage(userContext.getShanglian(), userContext.getXialian(), sReverseHengpi);
            }
            else
            {
                var fIsForwardCheckHengpi = false;
                var context = new Utility.RequestContext(userContext.getShanglian(), userContext.getXialian(), sReverseHengpi, "", 2, 3, fIsForwardCheckHengpi);
                IsValidChineseString(sReverseHengpi, context);
            }
            break;
    }
    
}


// This is the callback function invoked if the Web service failed.
// It accepts the error object as a parameter.
function CheckValidFailedCallbackWithContext(error,userContext, methodName)
{
    ShowWaitIndicator( gConst_display_none, gConst_AlertDiv, '' );
    var currentStep = userContext.getStepFrom();
    var errorCode = parseInt(error.get_message().split("|")[0]);
    switch(currentStep)
    {
        case 0: 
            ShowCheckValidErrorMsg(errorCode, $get(g_const_btnGetXialian), "上联");
            break;
        case 1:
            ShowCheckValidErrorMsg(errorCode, $get(g_const_btnGetXialian), "上/下联");
            break;
        case 2:
            var cHengpi = $find(gConst_divHengPiResults);
            ShowCheckValidErrorMsg(errorCode, cHengpi.get_inputHengpiElement(), "横批");
            break;
    }
}

function ShowCheckValidErrorMsg(errorCode, referencedDOMObject, subject)
{
    var errorMsg = g_const_sErrorMsgSystemBusy;
    switch(errorCode)
    {
        case CONST_ERROR_CHECK_VALID_NULLOREMPTY: 
            if("上联" == subject)
            {
                errorMsg = g_const_sErrorMsgInputShanglianFirst;
            }
            else
            {
                errorMsg = "对不起，请先填写" + subject + "，再继续。";
            }
            break;
        case CONST_ERROR_COUPLET_NOT_CHINESE:
            errorMsg = g_const_sErrorMsgInputChineseString;
            break;
        
        case CONST_ERROR_COUPLET_INVALID_CHINESE :
            errorMsg = "对不起，" + subject + "包含不恰当的词语。";
            break;
        case CONST_ERROR_CHECK_VALID_OTHERS :
            errorMsg = "对不起，输入\"" + subject + "\"错误。";
            break;
    }
    
    if(referencedDOMObject.id == g_const_btnGetXialian)
    {
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), errorMsg, -365, 105);
    }
    else if(referencedDOMObject.id == g_const_btnShowCouplet)
    {
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), errorMsg, -365, 170);
    }
    else
    {
        ShowCoupletErrorMsg(0, $get(g_const_imgHelp), errorMsg, -365, 135);
    }
}


if (typeof(Sys) !== "undefined") Sys.Application.notifyScriptLoaded();
